(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4243,        146]*)
(*NotebookOutlinePosition[      5366,        182]*)
(*  CellTagsIndexPosition[      5238,        175]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\(<< Statistics`DiscreteDistributions`\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(PoissPDF[k_, N_, dt_, f_] := 
      PDF[PoissonDistribution[N*f*dt], k]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?PoissPDF\)\)], "Input"],

Cell["Global`PoissPDF", "Print",
  CellTags->"Info3362307184-6683970"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(PoissPDF[k_, N_, dt_, f_] := 
                    PDF[PoissonDistribution[N\ f\ dt], k]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ "PoissPDF"],
      Editable->False]], "Print",
  CellTags->"Info3362307184-6683970"]
}, Open  ]],

Cell[BoxData[
    \(Trigger[nTh_, N_, dt_, f_] := 
      Evaluate[Sum[
            PoissPDF[k, N, 5/10^9, f]*
              PoissPDF[nTh - k, N, dt, 
                f]*\((1 - Sum[PoissPDF[j, N, 5/10^9, f], {j, 0, k}])\), {k, 
              0, nTh}]]*\((10^9/5)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Trigger\)\)], "Input"],

Cell["Global`Trigger", "Print",
  CellTags->"Info3362307731-1140847"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(Trigger[nTh_, N_, dt_, f_] := 
                    1\/5\ Evaluate[\[Sum]\+\(k = 0\)\%nTh PoissPDF[k, N, 
                              5\/10\^9, f]\ PoissPDF[nTh - k, N, dt, 
                              f]\ \((1 - \[Sum]\+\(j = 0\)\%k PoissPDF[j, N, 
                                    5\/10\^9, f])\)]\ 10\^9\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ "Trigger"],
      Editable->False]], "Print",
  CellTags->"Info3362307731-1140847"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Trigger[133, 81000, 425/10^9, 3\ 10^3]]\)], "Input"],

Cell[BoxData[
    \(57679.52805210537`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(0.000285805480422623`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[PoissPDF[249, 81000, 425/10^9, 6\ 10^3]*81000*6*10^3]\)], "Input"],

Cell[BoxData[
    \(205465.67261408278`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{495, 527},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3362307184-6683970"->{
    Cell[1991, 63, 70, 1, 25, "Print",
      CellTags->"Info3362307184-6683970"],
    Cell[2064, 66, 512, 14, 44, "Print",
      CellTags->"Info3362307184-6683970"]},
  "Info3362307731-1140847"->{
    Cell[2940, 96, 69, 1, 25, "Print",
      CellTags->"Info3362307731-1140847"],
    Cell[3012, 99, 736, 17, 77, "Print",
      CellTags->"Info3362307731-1140847"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3362307184-6683970", 4849, 161},
  {"Info3362307731-1140847", 5046, 166}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 105, 2, 50, "Input"],
Cell[1813, 54, 104, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[1942, 60, 46, 1, 30, "Input"],
Cell[1991, 63, 70, 1, 25, "Print",
  CellTags->"Info3362307184-6683970"],
Cell[2064, 66, 512, 14, 44, "Print",
  CellTags->"Info3362307184-6683970"]
}, Open  ]],
Cell[2591, 83, 276, 6, 130, "Input"],

Cell[CellGroupData[{
Cell[2892, 93, 45, 1, 30, "Input"],
Cell[2940, 96, 69, 1, 25, "Print",
  CellTags->"Info3362307731-1140847"],
Cell[3012, 99, 736, 17, 77, "Print",
  CellTags->"Info3362307731-1140847"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3785, 121, 74, 1, 30, "Input"],
Cell[3862, 124, 52, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3951, 130, 37, 1, 30, "Input"],
Cell[3991, 133, 55, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4083, 139, 88, 1, 30, "Input"],
Cell[4174, 142, 53, 1, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

